/*
 *
 *
 *
 * DEBUT FONCTIONS TERMINEES
 *
 *
 *
 */


// Mise à jour de la valeur clinimètre après changement sur le thermomètre
// Met à jour le score visuellement et l'injecte dans le localStorage
function updateThermometre(that) {

    var valeur_champ = $(that).find('input').val();

    // Convertir valeur de précision du range en valeur clinimetre et grille
    var lvlthermo = __LVLTHERMOMIN__;
    var pasthermo = __NBLVLTHERMO__ / __NBLVLCLINIMETRE__;
    var lvlclinimetre = __LVLCLINIMETREMIN__;

    for (lvlthermo; lvlthermo < __NBLVLTHERMO__; lvlthermo += pasthermo) {

        if (valeur_champ >= lvlthermo && valeur_champ < lvlthermo + pasthermo) {
            var valclinimetre = lvlclinimetre;
            var valgrille = clinimetreToGrille(valclinimetre);
        }
        lvlclinimetre++;
    }

    // On met à jour le curseur
    updateCurseur(valeur_champ);

    // On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(valclinimetre);

    // On met à jour le détail du score de la fonction courante
    updateSubGrille(valgrille);

    // On met à jour le score à partir du localStorage
    updateScore();
    
}


// Met à jour visuellement le radar d'après le localStorage
function updateRadar(idGrilleInput) {
    var idGrille;
    if (typeof idGrilleInput == 'undefined') {
        idGrille = __DOCTEUR__.idLastGrille;
    }
    else {
        idGrille = idGrilleInput;
    }
    var listeFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;

    // Liste de valeurs la plus récente
    var valeursGrille = getCurrentDataGrille();

    // CORRECTION DE BUG : Petite astuce pour les Android qui habituellement affichent 2 radars donc un fixe...
    if (__TERMINAL__ == 'Android') {
        // On supprime le radar
        $('#spidergraphcontainer').html();

        // Et on en génère un nouveau
        $('#spidergraphcontainer').spidergraph({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });
        updateScore();
        
        
    }

    // Sinon on vide le layer actuel
    else {
        if (idGrille == 1) {

            $('#spidergraphcontainer').spidergraph('resetdata');
        }
        if (idGrille == 2) {
            $('#spidergraphcontainer').spidergraph2('resetdata');
        }
        if (idGrille == 3) {
            $('#spidergraphcontainer').spidergraph3('resetdata');
        }
        if (idGrille == 4) {
            $('#spidergraphcontainer').spidergraph4('resetdata');
        }
        if (idGrille == 5) {
            $('#spidergraphcontainer').spidergraph5('resetdata');
        }
        if (idGrille == 6) {
            $('#spidergraphcontainer').spidergraph6('resetdata');
        }
        if (idGrille == 7) {
            $('#spidergraphcontainer').spidergraph7('resetdata');
        }
        if (idGrille == 8) {
            $('#spidergraphcontainer').spidergraph8('resetdata');
        }
        if (idGrille == 9) {
            $('#spidergraphcontainer').spidergraph9('resetdata');
        }
        if (idGrille == 10) {
            $('#spidergraphcontainer').spidergraph10('resetdata');
        }

    }

    // Pour en installer un nouveau
    if (idGrille == 1) {
        $('#spidergraphcontainer').spidergraph('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }

    if (idGrille == 2) {
        $('#spidergraphcontainer').spidergraph2('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }

    if (idGrille == 3) {
        $('#spidergraphcontainer').spidergraph3('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 4) {
        $('#spidergraphcontainer').spidergraph4('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 5) {
        $('#spidergraphcontainer').spidergraph5('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 6) {
        $('#spidergraphcontainer').spidergraph6('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 7) {
        $('#spidergraphcontainer').spidergraph7('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 8) {
        $('#spidergraphcontainer').spidergraph8('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 9) {
        $('#spidergraphcontainer').spidergraph9('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 10) {
        $('#spidergraphcontainer').spidergraph10('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }


    // CORRECTION DE BUG : Reselectionne le bon champs d'entrée de radar
    var i = parseInt($('#thermometre').attr('name'));
    updateCurrentFonctionName(i);

}


// Récréé intégralement le radar

function createRadar(idGrilleInput) {
    var idGrille;
    if (typeof idGrilleInput == 'undefined') {
        idGrille = __DOCTEUR__.idLastGrille;
    }
    else {
        idGrille = idGrilleInput;
    }

    //var idGrille = __DOCTEUR__.idLastGrille;
    var listeFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;

    // Liste de valeurs la plus récente
    var valeursGrille = getCurrentDataGrille();

    // On supprime le radar
    $('#spidergraphcontainer').html();

    // Et on en génère un nouveau
    if (idGrille == 1) {
        $('#spidergraphcontainer').spidergraph({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 2) {
        $('#spidergraphcontainer').spidergraph2({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph2('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 3) {
        $('#spidergraphcontainer').spidergraph3({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph3('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 4) {
        $('#spidergraphcontainer').spidergraph4({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph4('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }

    if (idGrille == 5) {
        $('#spidergraphcontainer').spidergraph5({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph5('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 6) {
        $('#spidergraphcontainer').spidergraph6({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph6('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 7) {
        $('#spidergraphcontainer').spidergraph7({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph7('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 8) {
        $('#spidergraphcontainer').spidergraph8({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph8('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 9) {
        $('#spidergraphcontainer').spidergraph9({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph9('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });
    }
    if (idGrille == 10) {
        $('#spidergraphcontainer').spidergraph10({
            'fields': listeFonctions,
            'gridcolor': 'rgba(0,0,0,1)'
        });

        // Pour en installer un nouveau
        $('#spidergraphcontainer').spidergraph10('addlayer', {
            'strokecolor': 'rgba(0,0,0,1)',
            'fillcolor': __FILLCOLOR__,
            'data': valeursGrille,
            'linear': true
        });

    }

    // CORRECTION DE BUG : Reselectionne le bon champs d'entrée de radar
    var i = parseInt($('#thermometre').attr('name'));
    updateCurrentFonctionName(i);
    updateScore();
    
}


// Sauvegarde une valeur clinimetre dans le LocalStorage
function saveLSClinimetreValue(valeur, idFonction, idPatient, idGrille, date) {

    // Attributs et initialisation
    if (typeof valeur != 'undefined') {

        console.log('Mise à jour du localStorage...');

        idGrille = __DOCTEUR__.idLastGrille;
        var idFctn = parseInt($('#thermometre').attr('name'));
        var updatesDates = getClinimetreUpdatesDates();

        if (typeof idFonction == 'undefined') {
            idFonction = parseInt(__LISTEGRILLES__[idGrille].idFonctions[idFctn]);
        }
        if (typeof idPatient == 'undefined') {
            idPatient = __DOCTEUR__.idLastPatient;
        }
        if (typeof date == 'undefined') {
            date = __PARAMETRES__.currentDate;
        }

        var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;


        // On met à jour les variables globales (?)
        __DONNEESCLINIMETRE__ = JSON.parse(localStorage.getItem('donneesClinimetre'));

        // On insère la nouvelle valeur
        __DONNEESCLINIMETRE__[idPatient][idGrille][idFonction][date] = { 'id': '1', 'valeur': parseInt(valeur) };

        // On met à jour le localStorage (on supprime d'abord la valeur puis on injecte la nouvelle)
        localStorage.removeItem('donneesClinimetre');
        localStorage.setItem('donneesClinimetre', JSON.stringify(__DONNEESCLINIMETRE__));

        console.log('localStorage à jour !');

    }
    else {
        console.log('Aucune valeur renseignee');
    }
}


// Modifie la date de l'analyse/objectifs courant dans le localStorage
function saveLSDate() {
    var idGrille = __DOCTEUR__.idLastGrille;
    var idPatient = __DOCTEUR__.idLastPatient;
    var updatesDates = getClinimetreUpdatesDates();
    var dateObjectifs = updatesDates[updatesDates.length - 1];

    var idFonction = parseInt(__LISTEGRILLES__[idGrille].idFonctions[i]);

    for (var i = 0; i < __LISTEGRILLES__[idGrille].idFonctions.length; i++) {
        idFonction = parseInt(__LISTEGRILLES__[idGrille].idFonctions[i]);
        // On applique les anciennes données dans la nouvelle date
        __DONNEESCLINIMETRE__[idPatient][idGrille][idFonction][__PARAMETRES__.currentDate] = __DONNEESCLINIMETRE__[idPatient][idGrille][idFonction][dateObjectifs];

        // Puis on supprime l'ancienne date
        delete __DONNEESCLINIMETRE__[idPatient][idGrille][idFonction][dateObjectifs];
    }

    // On met à jour le localStorage (on supprime d'abord la valeur puis on injecte la nouvelle)
    localStorage.removeItem('donneesClinimetre');
    localStorage.setItem('donneesClinimetre', JSON.stringify(__DONNEESCLINIMETRE__));
}


// Fonction de traitement lors de l'appui sur la flèche du bas
function fonctionSuivante() {

    // Infos sur la grille
    var idGrille = __DOCTEUR__.idLastGrille;
    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;

    // Liste de valeurs la plus récente
    var valeursGrille = getCurrentDataGrille();

    var grillefonction = $('#grille_fonction');
    var i = parseInt(grillefonction.attr("name"));
    var newVal = '';

    // Gestion en boucle (dernier -> premier)
    if (i == nbChampsGrille - 1) {
        newVal = __LISTEGRILLES__[idGrille].libelleFonctions[0];
        i = 0;
    } else {
        newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i + 1];
        i++;
    }

    // Mise à jour du texte
    grillefonction.html(newVal);

    updateCurrentFonctionName(i);

    // On met à jour le curseur
    var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
    var valthermo = valeursGrille[i] * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);

    updateCurseur(valthermo);

    // On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i], __DOCTEUR__.idLastGrille));

    // On met à jour le détail du score de la fonction courante
    updateSubGrille(valeursGrille[i]);
    updateScore();
    
}

// Fonction de traitement lors de l'appui sur la flèche du haut
function fonctionPrecedente() {

    // Infos sur la grille
    var idGrille = __DOCTEUR__.idLastGrille;
    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;

    // Liste de valeurs la plus récente
    var valeursGrille = getCurrentDataGrille();

    var grillefonction = $('#grille_fonction');
    i = parseInt(grillefonction.attr("name"));
    var newVal = '';

    // Gestion en boucle (premier -> dernier)
    if (i == 0) {
        newVal = __LISTEGRILLES__[idGrille].libelleFonctions[nbChampsGrille - 1];
        i = nbChampsGrille - 1;
    } else {
        newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i - 1];
        i--;
    }

    // Mise à jour du texte
    grillefonction.html(newVal);

    updateCurrentFonctionName(i);

    // On met à jour le curseur
    var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
    var valthermo = valeursGrille[i] * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);

    updateCurseur(valthermo);

    // On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i], __DOCTEUR__.idLastGrille));

    // On met à jour le détail du score de la fonction courante
    updateSubGrille(valeursGrille[i]);
    updateScore();

}

// Insert le nom de la fonction courante
// après changement via les flèche, le radar ou la liste
function updateCurrentFonctionName(i) {

    // Infos sur la grille
    var idGrille = __DOCTEUR__.idLastGrille;
    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;

    // Mise à jour du nom du texte
    $('#grille_fonction').attr("name", i);

    // Répercutions sur le thermometre, la liste et le radar
    $('#thermometre').attr("name", i);

    $('.fonctions_liste_ligne').removeClass("fonction_current");
    $('.fonctions_liste_ligne').eq(i).addClass("fonction_current");

    $('.diagramText').removeClass("fonction_current");
    $('.diagramText').eq(nbChampsGrille - i - 1).addClass("fonction_current");
    updateScore();
}

// Met en avant la fonction courante sur le radar
function clickTextRadar(i) {

    // Infos sur la grille
    var idGrille = __DOCTEUR__.idLastGrille;
    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;

    // Liste de valeurs la plus récente
    var valeursGrille = getCurrentDataGrille();

    var grillefonction = $('#grille_fonction');
    var newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i];

    // Mise à jour du texte
    grillefonction.html(newVal);

    updateCurrentFonctionName(i);

    // On met à jour le curseur
    var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
    var valthermo = valeursGrille[i] * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);

    updateCurseur(valthermo);

    // On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i], __DOCTEUR__.idLastGrille));

    // On met à jour le détail du score de la fonction courante
    updateSubGrille(valeursGrille[i]);
    updateScore();

}

// Met en avant la fonction courante sur la liste
function clickTextSondage(i) {
    clickTextRadar(i);
}


// Mise à jour du détail de la fonction courante
function updateSubGrille(valgrille) {
    var detail = $("#fonction_detail");
    var id = valgrille - __LISTEGRILLES__[__DOCTEUR__.idLastGrille].nivGrilleMin;
    detail.text(__LISTEGRILLES__[__DOCTEUR__.idLastGrille].listeDescValeursGrille[id]);
    updateScore();
    
}


// Renvoie les valeurs les plus récentes de la grille actuelle d'après le localStorage
function getCurrentDataGrille(date) {

    // Init
    date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;

    var valeursClinimetre = getCurrentDataClinimetre(date);
    var valeursGrille = [];

    for (var i = 0; i < valeursClinimetre.length; i++) {
        // On insère la valeur convertie
        valeursGrille.push(clinimetreToGrille(valeursClinimetre[i]));
    }
    console.log("Valeurs grille les plus proche (datant du " + __PARAMETRES__.currentDate + ") : " + valeursGrille);
    return valeursGrille;
}


// Renvoie les valeurs les plus récentes du clinimetre actuel d'après le localStorage
function getCurrentDataClinimetre(date) {

    // Init
    date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;

    var id_grille = __DOCTEUR__.idLastGrille;
    var id_patient = __DOCTEUR__.idLastPatient;
    var nbChampsGrille = __LISTEGRILLES__[id_grille].libelleFonctions.length;
    var donneesPatient = __DONNEESCLINIMETRE__[id_patient];
    var idFonctions = __LISTEGRILLES__[id_grille].idFonctions;

    console.log("miwehola : " + JSON.stringify(idFonctions));


    var valeursClinimetre = [];
    var strDte = '';

    var offset = -1;
    if (dateToString() < __PARAMETRES__.currentDate) {
        offset = 1;
    }

    var flag = 'ok';

    // Déterminer la date de la dernière modification
    var lastUpdate = '0000/00/00';


    for (var i = 0; i < nbChampsGrille; i++) {
        var fini = false;
        var currentDate = new Date(date);
        //strDte = dateToString(currentDate);

        // On insère une valeur par défaut
        valeursClinimetre.push(0);


        //console.log("Naoufal les donnees du patient : "+id_patient+" de la grille : "+id_grille+" sont : "+JSON.stringify(donneesPatient[9]));
        //console.log("Hola is hmm: "+JSON.stringify(__LISTEGRILLES__[4].repGrille[4]));


        //console.log("Naoufal les questions sont : "+ JSON.stringify(__LISTEGRILLES__[id_grille].questionGrille));
        // Longueur de l'historique max (1 an)
        var j = 365;
        while (!fini) {


            //fini = true;

            // Modification de la date de la recherche
            strDte = dateToString(currentDate);
            if (typeof donneesPatient !== 'undefined') {

                if (typeof donneesPatient[id_grille][idFonctions[i]][strDte] !== 'undefined') {
                    //console.log("Naoufal les donnees du patient : "+id_patient+" de la grille : "+id_grille+" sont : "+JSON.stringify(donneesPatient[id_grille][idFonctions[i]]));
                    // Insertion de la valeur
                    valeursClinimetre[i] = donneesPatient[id_grille][idFonctions[i]][strDte].valeur;

                    // Mise à jour de la date de la dernière modification
                    //console.log(i + ' : ' + lastUpdate +'; '+ strDte);
                    if (lastUpdate < strDte) {
                        lastUpdate = strDte;
                    }

                    fini = true;
                }



                // On arrete la recherche au bout d'un nombre d'execution donné
                else {
                    console.log("Les valeurs enregistrees sont erronees.");
                    //flag = 'nok';
                    fini = true;
                }

                currentDate.setDate(currentDate.getDate() + offset);
                j--;
            }
        }
    }

    if (flag == 'nok') {

    }
    //__PARAMETRES__.currentDate = lastUpdate;

    // Si on cherche des données futures pour l'analyse et objectifs
    /*if(offset == 1) {

     // Si on a trouvé des valeurs dans le futur
     if(flag == 'ok') {
     // On applique la date des analyses et objectifs
     __PARAMETRES__.currentDate = strDte;

     } else {
     // On applique la date du jour + 14
     var tdy = new Date();
     __PARAMETRES__.currentDate = dateToString(tdy);

     // On restitue les valeursClinimetre du jour
     valeursClinimetre = getCurrentDataClinimetre();

     // On applique la date du jour + 14
     tdy.setDate(tdy.getDate() + 14);
     __PARAMETRES__.currentDate = dateToString(tdy);
     }
     }*/

    console.log("Valeurs clinimetre les plus proche (datant du " + __PARAMETRES__.currentDate + ") : " + valeursClinimetre);
    return valeursClinimetre;
}


// Renvoie les dates des dernières mise à jour sur les données
function getClinimetreUpdatesDates() {

    var id_grille = __DOCTEUR__.idLastGrille;
    var id_patient = __DOCTEUR__.idLastPatient;
    var date = __PARAMETRES__.currentDate;
    var nbChampsGrille = __LISTEGRILLES__[id_grille].libelleFonctions.length;
    var donneesPatient = __DONNEESCLINIMETRE__[id_patient];
    var idFonctions = __LISTEGRILLES__[id_grille].idFonctions;

    var strDte = '';
    var updatesDates = [];

    // Aujourd'hui
    var tdy = new Date();
    var strtdy = dateToString(tdy);
    updatesDates.push(strtdy);

    for (var i = 0; i < nbChampsGrille; i++) {
        var fini = false;
        var currentDate = new Date();
        currentDate.setDate(currentDate.getDate() + 14);

        // Longueur de l'historique max (1 an)
        var j = 365;

        while (!fini) {

            // Modification de la date de la recherche
            strDte = dateToString(currentDate);
            if (typeof donneesPatient !== 'undefined') {

                if (typeof donneesPatient[id_grille][idFonctions[i]][strDte] !== 'undefined' &&
                    updatesDates.indexOf(strDte) == -1) {

                    // Mise à jour de la date de la dernière modification
                    updatesDates.push(strDte);

                    fini = true;
                }


                // On arrete la recherche au bout d'un nombre d'execution donné
                else if (j == 0) {
                    console.log("Les valeurs enregistrees sont erronees.");
                    fini = true;
                }

                currentDate.setDate(currentDate.getDate() - 1);
                j--;
            }
        }
    }

    return updatesDates.sort();
}


// Renvoie la date de la dernière mise à jour par rapport a une date
function getClinimetreLastUpdateDate(date) {

    date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;
    var updatesDates = getClinimetreUpdatesDates();

    var res = '';
    var fini = false;

    var i = updatesDates.length;

    while (i > 0 || !fini) {

        // Valeur la plus proche de la date
        if (updatesDates[i] <= date) {
            res = updatesDates[i];
            fini = true;
        }

        i--;
    }

    return res;
}


// Transforme une date en une chaine (gestion des 9 premiers jours)
function dateToString(date) {

    date = typeof date !== 'undefined' ? date : new Date();

    var jr = date.getDate();
    if (jr >= 1 && jr <= 9) {
        jr = "0" + jr;
    }

    var mois = date.getMonth() + 1;
    if (mois >= 1 && mois <= 9) {
        mois = "0" + mois;
    }

    var res = date.getFullYear() + "/" + mois + "/" + jr;

    return res;
}


// Position le curseur à l'endroit du clic
function updateCurseur(valgrille) {

    var margin = (82 * valgrille) / __NBLVLTHERMO__ + 9;
    $("#thermometre_curseur").css('margin-left', margin + '%');
}


// Identifie l'evaluateur
// Recupère les données depuis la base de données
// Peuple le localStorage
function loadFromLocalStorage(varlogin, varpasswd) {

    var flag = 'nok';

    // Si le navigateur est en ligne
    if (navigator.onLine) {

        console.log("Mode en-ligne");

        var requete = $.ajax({
            url: "include/getAllData.php",
            type: "GET",
            data: { 'login': varlogin, 'passwd': varpasswd },
            dataType: "json",
            async: false,
            success: function (res) {

                if (res.flag == 'ok') {

                    /*

                     IL FAUT SYNCHRONISER LE LOCALSTORAGE ET LA BDD
                     ET NON ECRASER LE LS AVEC LA BDD

                     */

                    localStorage.clear();

                    console.log("Vous etes correctement identifie");
                    //console.log("Mise a jour du localStorage depuis la bdd");

                    var varEtablissement = res.etablissement;
                    localStorage.setItem('etablissement', JSON.stringify(varEtablissement));

                    var varDocteur = res.docteur;
                    localStorage.setItem('docteur', JSON.stringify(varDocteur));

                    var varListePatients = res.patients;
                    localStorage.setItem('listePatients', JSON.stringify(varListePatients));

                    var varListeGrilles = res.grilles;
                    localStorage.setItem('listeGrilles', JSON.stringify(varListeGrilles));

                    var varDonneesClinimetre = res.donneesclinimetre;
                    localStorage.setItem('donneesClinimetre', JSON.stringify(varDonneesClinimetre));

                    var varParametres = res.parametres;

                    var varReponsePatient = res.reponsepatient;
                    localStorage.setItem('reponsePatient', JSON.stringify(varReponsePatient));


                    //NAOUFALLAAAA 
                    //var varQuestionsGrille = res.questions_grille;
                    //localStorage.setItem('questions_grille', JSON.stringify(varQuestionsGrille));


                    varParametres.currentPage = "pageDeConnexion";
                    varParametres.currentDate = dateToString();

                    localStorage.setItem('parametres', JSON.stringify(varParametres));

                    flag = 'ok';

                }
                else {
                    console.log("Impossible de recuperer les informations. Vous n'etes pas correctement identifie.");
                    alert("Impossible de recuperer les informations. Vous n'etes pas correctement identifie.");
                }
            }
        }).done(function () {

            console.log('##### MISE A JOUR DU LOCALSTORAGE DEPUIS LA BDD : ' + flag + ' #####');
        });

    }

    else {

        alert("Vous etes mode hors-ligne. Connectez-vous a un reseau mobile ou wifi afin de recuperer les dernieres donnees");
        console.log('##### MISE A JOUR DU LOCALSTORAGE DEPUIS LA BDD : ' + flag + ' #####');
    }

    if (varlogin == JSON.parse(localStorage.getItem('docteur')).login &&
        varpasswd == JSON.parse(localStorage.getItem('docteur')).passwd) {

        flag = 'nok';

        // On recupere le contenu du localStorage
        if (localStorage.getItem('docteur') !== null) {
            __DOCTEUR__ = JSON.parse(localStorage.getItem('docteur'));
        }

        if (localStorage.getItem('etablissement') !== null) {
            __ETABLISSEMENT__ = JSON.parse(localStorage.getItem('etablissement'));
        }

        if (localStorage.getItem('listePatients') !== null) {
            __LISTEPATIENTS__ = JSON.parse(localStorage.getItem('listePatients'));
        }

        if (localStorage.getItem('listeGrilles') !== null) {
            __LISTEGRILLES__ = JSON.parse(localStorage.getItem('listeGrilles'));
        }

        if (localStorage.getItem('reponsePatient') !== null) {
            __REPONSEPATIENT__ = JSON.parse(localStorage.getItem('reponsePatient'));
        }

        if (localStorage.getItem('donneesClinimetre') !== null) {
            __DONNEESCLINIMETRE__ = JSON.parse(localStorage.getItem('donneesClinimetre'));
            //__QUESTION_GRILLE__ = JSON.parse(localStorage.getItem('questions_grille'));
        }

        if (localStorage.getItem('parametres') !== null) {
            __PARAMETRES__ = JSON.parse(localStorage.getItem('parametres'));
        }

        flag = 'ok';
        console.log('##### MISE A JOUR DES VARIABLES GLOBALES DEPUIS LE LOCALSTORAGE : ' + flag + ' #####');
    }
}


// Charge une page choisie
function loadPage(pageToLoad) {

    // Si pageToLoad n'est pas renseigné, on va sur "pageRadar" par defaut
    pageToLoad = typeof pageToLoad !== 'undefined' ? pageToLoad : "pageDeConnexion";


    // On change la page courante enregistrée
    __PARAMETRES__.currentPage = pageToLoad;
    localStorage.removeItem('parametres');
    localStorage.setItem('parametres', JSON.stringify(__PARAMETRES__));

    // Preparation des informations
    var idPatient = __DOCTEUR__.idLastPatient;
    var idGrille = __DOCTEUR__.idLastGrille;

    var nomPatient = __LISTEPATIENTS__[idPatient].nom;
    var prenomPatient = __LISTEPATIENTS__[idPatient].prenom;
    var sexePatient = __LISTEPATIENTS__[idPatient].sexe;
    var numDossierPatient = __LISTEPATIENTS__[idPatient].num_dossier;

    var questions = __LISTEGRILLES__[idGrille].questionGrille;

    var libelleGrille = __LISTEGRILLES__[idGrille].libelle;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
    var libelleFonction = __LISTEGRILLES__[idGrille].libelleFonctions[0];

    var donneesPatient = __DONNEESCLINIMETRE__[idPatient][idGrille];
    var valeursGrille = getCurrentDataGrille();

    var corps = '';

    if (pageToLoad != 'pageDeConnexion') {

        // ### Masquage du formulaire de connexion ###

        var formconnexion = $('#blocconnexion');

        // On masque le formulaire de connexion celui-ci était affiché
        if (!formconnexion.hasClass('hidden')) {
            formconnexion.addClass('hidden');
        }

        // ### Affichage des bandeaux 3 et 4, de la flèche du haut et du footer ###

        var bandeau3 = $('#troisieme_bandeau');
        var bandeau4 = $('#quatrieme_bandeau');
        var flechehaut = $('#fleche_haut');
        var footer = $('footer');

        // On affiche le bandeau 3 si celui-ci était caché
        if (bandeau3.hasClass('hidden')) {
            bandeau3.removeClass('hidden');
        }

        // On affiche le bandeau 4 si celui-ci était caché
        if (bandeau4.hasClass('hidden')) {
            bandeau4.removeClass('hidden');
        }

        // On affiche la flèche du haut si celle-ci était cachée
        if (flechehaut.hasClass('hidden')) {
            flechehaut.removeClass('hidden');
        }

        // On affiche le footer si celui-ci était caché
        if (footer.hasClass('hidden')) {
            footer.removeClass('hidden');
        }

        // ### Insertion des valeurs dans les champs ###

        var etablissement = $('#etablissement');
        var infospatient = $('#infos_patient');

        // On affiche le champs si celui-ci était caché et on cache l'etablissement
        if (infospatient.hasClass('hidden')) {
            infospatient.removeClass('hidden');
            etablissement.addClass('hidden');
        }

        // On met à jour les infos du patient
        infospatient.html(nomPatient + ' ' + prenomPatient + '<br /> (' + sexePatient + ') n.' + numDossierPatient);

        // On met à jour le nom de la grille
        var grillenom = $('#grille_nom');
        grillenom.html(libelleGrille);

        // On met à jour le nom de la fonction
        var grillefonction = $('#grille_fonction');
        grillefonction.html(libelleFonction);
        grillefonction.attr("name", 0);

        // On met à jour le détail du score de la fonction
        var fonctiondetail = $('#fonction_detail');
        var valfonction = getCurrentDataClinimetre()[0];
        var detail = __LISTEGRILLES__[idGrille].listeDescValeursGrille[clinimetreToGrille(valfonction) - 1];
        fonctiondetail.html(detail);
        fonctiondetail.attr("name", clinimetreToGrille(valfonction));

        // On met à jour la valeur clinimetre
        var valclini = $('#valeurclinimetre');
        valclini.html(valfonction);

        // On met à jour la valeur grille
        var valgrille = $('#valeurgrille');
        valgrille.html(clinimetreToGrille(valfonction));

        // On indique la fonction courante au thermometre
        var thermometre = $('#thermometre');
        thermometre.attr("name", '0');

        // On met à jour le curseur
        var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
        var valthermo = valeursGrille[0] * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);

        updateCurseur(valthermo);

        // On met à jour la date
        var date = $('#date');
        date.html(__PARAMETRES__.currentDate);

    }


    // ### PRETRAITEMENT SUR LA HAUTEUR DU BLOC DE CONTENU ###

    var y = Math.min(document.documentElement.clientWidth, document.documentElement.clientHeight - 422);

    var contenu = $('.contenu');

    // On masque tous les contenus avant de les afficher
    contenu.addClass('hidden');

    // ### DEBUT LISTE.PHP ###
    /*Si la page à charger est liste patient on recharge la page courante et on met la variable
     searchPatient à 1 pour indiquer que le bloc de recherche de patient devrai etre afficher */
    if (pageToLoad == "choixPatient") {
        window.location.reload();
        sessionStorage.setItem('SearchPatient', 1);
    }

    if (pageToLoad == "pageListe") {

        console.log("Page liste");

        var listefonctions = $('#fonctions_liste');
        var corps = '<div style="margin-top:-85px;"';

        // On adapte la taille de la liste à l'espace réel restant
        listefonctions.css('height', y);

        // On affiche la liste des fonctions si celle-ci était cachée
        if (listefonctions.hasClass('hidden')) {
            listefonctions.removeClass('hidden');
        }

        // On affiche la première ligne
        corps += '<div class="fonctions_liste_ligne0 listesondage0"> ';
        corps += '<label class="fonctions_liste_nom" id="fonctions_liste_nom_00"> FONCTIONS </label>';
        for (var j = lvlgrillemin; j <= lvlgrillemax; j++) {
            corps += '<span class="fonctions_liste_valeur0 sondage">' + j + '</span>';
        }
        corps += '</div>';
        corps += '<div id="champs">';

        // On affiche toutes les fonctions
        for (var i = 0; i < nbChampsGrille; i++) {

            // On charge la ligne
            corps += '<div class="fonctions_liste_ligne listesondage';
            if (i == 0) {
                corps += ' fonction_current';
            }
            corps += '" id="fonctions_liste_ligne_' + i + '" name="' + i + '">';

            // On charge le nom de la fonction
            corps += '<label class="fonctions_liste_nom clickable" id="fonctions_liste_nom_' + i + '">' + __LISTEGRILLES__[idGrille].libelleFonctions[i] + '</label>';

            // On charge la valeur de la fonction
            corps += '<form class="fonctions_liste_valeurs" id="fonctions_liste_valeurs_' + i + '">';

            for (var j = lvlgrillemin; j <= lvlgrillemax; j++) {
                corps += '<input class="fonctions_liste_valeur sondage clickable" id="fonctions_liste_valeur_' + j + '" type="checkbox" value="' + j + '" ';

                // On coche l'input adéquat
                if (valeursGrille[i] == j) {
                    corps += ' checked';
                }

                corps += '/>';
            }

            corps += '</form>';

            corps += '</div>';

        }
        corps += '</div></div>';
        listefonctions.html(corps);
        //listefonctions.css('margin-top',-150);

        // Adapte la largeur des imputs
        var fonctionslistevaleur = $('.fonctions_liste_valeur');
        var fonctionslistenote = $('.fonctions_liste_valeur0');


        // valwidth = pourcentage pour gérer la largeur des inputs (magie)
        var valwidth = 65;
        var nbLvlTot = (lvlgrillemax - lvlgrillemin + 1);
        var valmargin = (valwidth / (nbLvlTot)) - 1.5;

        fonctionslistevaleur.css('width', valmargin + '%');
        fonctionslistenote.css('width', valmargin - 0.3 + '%');
        

    }

    if (pageToLoad == "pageQuestions") {

        console.log("Page Question");

        corps = '';
        var listefonctions = $('#questions');
        var corps = '<div><div>';
        corps += '<form id="myFormGrille">';
        for (var i = 0; i < questions.length; i++) {

            corps += '<strong>Question n°' + (i + 1) + ': </strong>' + questions[i][0] + '<br><span class="dateRG" id ="' + questions[i][2] + 'date"></span><br>';
            if (questions[i][1] == 'texte') {
                corps += '<textarea rows="4" cols="50" id="' + questions[i][2] + '" name="' + questions[i][2] + '" placeholder="Ecrivez votre texte ici"/><br>';
                corps += '<button onclick="saveOneResponse(' + questions[i][2] + ')">Enregistrer</button><br>';
            } else if (questions[i][1] == 'num') {
                corps += '<input type="number" id="' + questions[i][2] + '" name="' + questions[i][2] + '" min=0 ><br>';
                corps += '<button onclick="saveOneResponse(' + questions[i][2] + ')">Enregistrer</button><br>';
            } else if (questions[i][1] == 'O/N') {
                corps += '<input type="radio" id="' + questions[i][2] + '" name="' + questions[i][2] + '" value="Oui">Oui<br>';
                corps += '<input type="radio" id="' + questions[i][2] + 'sec" name="' + questions[i][2] + '" value="Non">Non<br>';
                corps += '<button onclick="saveOneResponse(' + questions[i][2] + ')">Enregistrer</button><br>';
            }

            corps += '<br>';
        }
        corps += '<input type="submit" id="btnReponsesGrille"  value="Enregistrer les reponses">';
        corps += '</form><br>';
        corps += '<button onclick="getResponseGrille()">Voir réponses</button><br>';

        corps += '</div></div>';


        // On adapte la taille de la liste à l'espace réel restant
        listefonctions.css('height', y + 55);
        listefonctions.css('width', 680);
        listefonctions.css('margin-top', 170);

        // On affiche la liste des fonctions si celle-ci était cachée
        if (listefonctions.hasClass('hidden')) {
            listefonctions.removeClass('hidden');
        }


        listefonctions.html(corps);
        //$("#3").prop("checked", false);

        var centrer = $('.centre');
        centrer.css('margin-left', '25%');
        centrer.css('font-size', '100%');


        fillResponseGrille(idGrille, idPatient);
        updateRadar();
        adaptListeRadarSize();
        createRadar();
    }

    if (pageToLoad == "pageRadar") {

        // ### DEBUT RADAR.PHP ###
        console.log("Page radar");

        var radar = $('#radar');
        var corps = '';

        // On adapte la taille de la liste à l'espace réel restant
        radar.css('height', y);

        // On affiche le radar si celui-ci était caché
        if (radar.hasClass('hidden')) {
            radar.removeClass('hidden');
        }

        // On adapte le radar a l'espace disponible
        adaptListeRadarSize();

        console.log("Debut radar");

        // On execute le script de création du radar
        $('#spidergraphcontainer').ready(function () {

            $('#spidergraphcontainer').spidergraph({
                'fields': __LISTEGRILLES__[idGrille].libelleFonctions,
                'gridcolor': 'rgba(0,0,0,1)'
            });

            $('#spidergraphcontainer').spidergraph('addlayer', {
                'strokecolor': 'rgba(0,0,0,1)',
                'fillcolor': __FILLCOLOR__,
                'data': valeursGrille,
                'linear': true
            });
        });

        updateRadar();
        adaptListeRadarSize();
        createRadar();


        console.log("Fin radar");

        // ### FIN RADAR ###
    }


    /*
     <span id="questionsReload1" name="mainpages" class="inactive" style="margin:auto; text-align:center;">

     <?php
     if ($_SESSION['id_grille'] == 1) {
     include('questionNum.php');
     }
     else {
     include('questionON.php');
     }
     ?>

     </span>

     <span id="questionsReload2" name="mainpages" class="inactive" style="margin:auto; text-align:center;">

     <?php
     if ($_SESSION['id_grille'] == 1) {
     include('questionNum2.php');
     }
     else {
     include('questionON2.php');
     }
     ?>

     </span>*/

    return corps;

}


function saveOneResponse(id_question) {

    var rep = document.getElementById(id_question);
    var idQuestion = '';
    var reponse = '';
    var id_patient = __DOCTEUR__.idLastPatient;

    console.log("testoto : " + rep);

    if (rep.type == 'radio') {
        if (rep.checked) {
            idQuestion = rep.name;
            reponse = rep.value;
        } else {
            idQuestion = rep.name;
            reponse = 'Non';
        }
    } else {
        idQuestion = rep.name;
        reponse = rep.value;
    }


    var request = $.ajax({
        url: "include/saveOneRGrille.php",
        type: "POST",
        data: {
            idQuestion: idQuestion,
            id_patient: id_patient,
            reponse: reponse
        },
        dataType: 'json',
        success: function (res) {
            console.log(res);

            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //January is 0!
            var yyyy = today.getFullYear();

            if (dd < 10) {
                dd = '0' + dd
            }

            if (mm < 10) {
                mm = '0' + mm
            }

            today = yyyy + '-' + mm + '-' + dd;
            $("#" + idQuestion + "date").text(today);
            // On montre visuellement que l'opération terminée avec succès
            //location.reload();


        },
        error: function () {

            alert("Erreur lors de l'enregistrement des reponses de cette grille: " + id_grille);
        }
    });

}

function fillResponseGrille(idGrille, idPatient) {
    var reponse = __LISTEGRILLES__[idGrille].repAll;
    for (var i = 0; i < reponse.length; i++) {
        if (reponse[i].id_patient == idPatient) {
            var id_question = reponse[i].id_question;
            if (reponse[i].type == 'O/N') {
                if (reponse[i].reponse == 'Oui') {
                    $("#" + id_question).prop("checked", true);
                } else {
                    $("#" + id_question + "sec").prop("checked", true);
                }
            } else {
                $("#" + id_question).val(reponse[i].reponse);
            }
            $("#" + id_question + "date").text(reponse[i].date);

        }

    }
}



function enregistrerReponsesGrille() {
    var id_grille = __DOCTEUR__.idLastGrille;
    var id_patient = __DOCTEUR__.idLastPatient;

    var reponsesGrille = [];

    var formQuestion = document.getElementById("myFormGrille").elements;
    for (var j = 0; j < formQuestion.length - 1; j++) {
        //console.log('best duck ever : type: '+formQuestion[j].type+' name: '+formQuestion[j].name);
        reponsesGrille[j] = [];

        if (formQuestion[j].type == 'radio') {
            if (formQuestion[j].checked) {
                reponsesGrille[j][0] = formQuestion[j].name;
                reponsesGrille[j][1] = formQuestion[j].value;
            }
        } else {
            reponsesGrille[j][0] = formQuestion[j].name;
            reponsesGrille[j][1] = formQuestion[j].value;
        }
    }
    reponsesGrille = reponsesGrille.filter(function (n) {
        for (var j = 0; j < n.length; j++) {
            return n[j] != [];
        }
    });


    console.log('haaaa daaamn:' + JSON.stringify(reponsesGrille));

    var request = $.ajax({
        url: "include/saveResponseGrille.php",
        type: "POST",
        data: {
            id_patient: id_patient,
            reponses: reponsesGrille
        },
        dataType: 'json',
        success: function (res) {
            console.log(res);

            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //January is 0!
            var yyyy = today.getFullYear();

            if (dd < 10) {
                dd = '0' + dd
            }

            if (mm < 10) {
                mm = '0' + mm
            }

            today = yyyy + '-' + mm + '-' + dd;
            for (var j = 0; j < reponsesGrille.length; j++) {

                $("#" + reponsesGrille[j][0] + "date").text(today);
            }

            // On montre visuellement que l'opération terminée avec succès
            //location.reload();


        },
        error: function () {

            alert("Erreur lors de l'enregistrement des reponses de cette grille: " + id_grille);
        }
    });

}

// Affiche les nouvelles valeurs aux côtés du thermomètre après mise à jour AGGIR
function updateValeurClinimetreGrille(val_clinimetre) {

    var valgrille = clinimetreToGrille(val_clinimetre);
    var idGrille = __DOCTEUR__.idLastGrille;

    if (idGrille == 2) {

        if (valgrille == 1)
            $("#valeurgrille").text("C");
        $("#valeurclinimetre").text(val_clinimetre);
        if (valgrille == 2)
            $("#valeurgrille").text("B");
        $("#valeurclinimetre").text(val_clinimetre);
        if (valgrille == 3)
            $("#valeurgrille").text("A");
        $("#valeurclinimetre").text(val_clinimetre);


    }

    else
        $("#valeurgrille").text(valgrille);
    $("#valeurclinimetre").text(val_clinimetre);


}


// Convertir une valeur clinimetre en valeur grille xxxxxxxxxx moquette
function clinimetreToGrille(val_clinimetre) {
    var idGrille = __DOCTEUR__.idLastGrille;
    var __LVLGRILLEMIN__ = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var __LVLGRILLEMAX__ = __LISTEGRILLES__[idGrille].nivGrilleMax;
    var __DELTALVLGRILLE__ = __LVLGRILLEMAX__ - __LVLGRILLEMIN__;
    var __DELTALVLCLINIMETRE__ = __NBLVLCLINIMETRE__ - 1;
    var res = (val_clinimetre - __LVLCLINIMETREMIN__) * __DELTALVLGRILLE__ / __DELTALVLCLINIMETRE__ + parseInt(__LVLGRILLEMIN__);
    if (val_clinimetre == 0) {
        res = 0;
    }
    return Math.round(res);
}

// Convertir une valeur grille en valeur clinimetre
function grilleToClinimetre(val_grille, idGrille) {
    idGrille = __DOCTEUR__.idLastGrille;
    var __LVLGRILLEMIN__ = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var __LVLGRILLEMAX__ = __LISTEGRILLES__[idGrille].nivGrilleMax;
    var __DELTALVLGRILLE__ = __LVLGRILLEMAX__ - __LVLGRILLEMIN__;
    var __DELTALVLCLINIMETRE__ = __NBLVLCLINIMETRE__ - 1;
    var res = (val_grille - __LVLGRILLEMIN__) * __DELTALVLCLINIMETRE__ / __DELTALVLGRILLE__ + parseInt(__LVLCLINIMETREMIN__);
    if (val_grille == 0) {
        res = 0;
    }
    return Math.round(res);
}


// Affiche le radar d'une date donnée (historique)
function getRadarDate(date) {

    // Aujourd'hui
    var tdy = new Date();
    var strtdy = dateToString(tdy);

    // Demain
    var tmw = new Date();
    tmw.setDate(tmw.getDate() + 1);

    // Couleur de l'historique
    __FILLCOLOR__ = 'rgba(255,0,0,0.5)';

    // Si on demande le radar d'aujourd'hui
    if (dateToString(date) == strtdy) {
        // Couleur d'origine
        __FILLCOLOR__ = 'rgba(193,195,198,0.5)';
    }

    // Si on demande le radar de demain
    if (dateToString(date) == dateToString(tmw)) {
        alert("Il faut attendre demain...");
    }

    // Sinon : cas historique
    else {
        console.log("Historique");

        // On modifie la date courante
        $('#date').html(__PARAMETRES__.currentDate);

        // On affiche le radar adequat
        if (__PARAMETRES__.currentPage == "pageRadar") {
            updateRadar();
        }

        // Ou affiche la liste adequate
        else if (__PARAMETRES__.currentPage == "pageListe") {
            console.log('refreshSondage');
            refreshSondage();
        }

        // On met à jour le curseur
        var idGrille = __DOCTEUR__.idLastGrille;
        var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
        var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
        var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
        var id = parseInt($('#thermometre').attr('name'));
        var valgrille = getCurrentDataGrille()[id];
        var valthermo = valgrille * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);
        updateCurseur(valthermo);

        // On met à jour les valeurs clinimetre et grille aux bords du thermomètre
        updateValeurClinimetreGrille(grilleToClinimetre(valgrille, idGrille));

        // On met à jour le détail du score de la fonction courante
        updateSubGrille(valgrille);

        // On interdit la mise à jour si on est pas aujourd'hui
        if (__PARAMETRES__.currentDate == strtdy) {
            console.log("On debloque le thermometre et la liste");
            $("#thermometre").hammer().unbind("release");
            $("#thermometre").find('input').unbind("change");
            $(".sondage").prop("disabled", false);
        }
        else {
            console.log("On bloque le thermometre et la liste");
            $("#thermometre").hammer().bind("release", false);
            $("#thermometre").find('input').bind("change", false);
            $(".sondage").prop("disabled", true);
        }

    }
}


// Insère dans la base de données les dernièrs objectifs enregistrés GOGOGO
function updateObjFromLocalStorage() {

    // Si le navigateur est en ligne
    if (navigator.onLine) {

        // Initialisation des variables
        var idEtablissement = __ETABLISSEMENT__.id;
        var idGrille = __DOCTEUR__.idLastGrille;

        var donneesClinimetre = getBufferedDataClinimetre();


        currentDate = new Date(__PARAMETRES__.dateLastSync);
        var strDte = dateToString(currentDate);


        //----------------------------------------------------------------------------------

        // transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
        // Car la date reste la même...

        var donneesClinimetreValeurs = [];

        for (var g = 1; g < donneesClinimetre.length; g++) {

            if (typeof donneesClinimetre[g] == 'undefined') {
                donneesClinimetreValeurs[g] = 0;
            }
            else {
                donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
            }

        }


        //----------------------------------------------------------------------------------


        var updatesDates = getClinimetreUpdatesDates();
        var dateObjectifs = updatesDates[updatesDates.length - 1];
        var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);


        // On montre visuellement qu'une opération est en cours
        $('body').css('opacity', 0.5);

        // Mise à jour des données actuelles
        var request = $.ajax({
            url: "include/updateDonneesObjectifs.php",
            type: "POST",
            data: {
                id_Etablissement: idEtablissement,
                docteur: JSON.stringify(__DOCTEUR__),
                donnees_Clinimetre_Valeur: donneesClinimetreValeurs,
                donnees_Clinimetre_Objectifs: donneesClinimetreObjectifs,
                date_Objectifs: dateObjectifs,
                id_Fonctions: __LISTEGRILLES__[idGrille].idFonctions
            },
            dataType: 'json',
            success: function (res) {
                console.log(res);
                // On montre visuellement que l'opération terminée avec succès
                $('body').css('opacity', 1);


            },
            error: function () {

                //alert("Erreur lors de l'enregistrement des donnees.");
            }
        });
    }

    // Si le navigateur est hors ligne
    else {
        alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
    }
}


// Insère dans la base de données les dernières valeurs enregistrées
function updateBDDFromLocalStorage() {

    // Si le navigateur est en ligne
    if (navigator.onLine) {

        // Initialisation des variables
        var idEtablissement = __ETABLISSEMENT__.id;
        var idGrille = __DOCTEUR__.idLastGrille;


        var donneesClinimetre = getBufferedDataClinimetre();


        currentDate = new Date(__PARAMETRES__.dateLastSync);
        var strDte = dateToString(currentDate);


        //----------------------------------------------------------------------------------

        // transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
        // Car la date reste la même...

        var donneesClinimetreValeurs = [];

        for (var g = 1; g < donneesClinimetre.length; g++) {

            if (typeof donneesClinimetre[g] == 'undefined') {
                donneesClinimetreValeurs[g] = 0;
            }
            else {
                donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
            }

        }


        //----------------------------------------------------------------------------------


        var updatesDates = getClinimetreUpdatesDates();
        var dateObjectifs = updatesDates[updatesDates.length - 1];
        var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);


        // On montre visuellement qu'une opération est en cours
        $('body').css('opacity', 0.5);

        // Mise à jour des données actuelles
        var request = $.ajax({
            url: "include/updateDonneesClinimetre.php",
            type: "POST",
            data: {
                id_Etablissement: idEtablissement,
                nbGrille: __LISTEGRILLES__.length,
                docteur: JSON.stringify(__DOCTEUR__),
                donnees_Clinimetre_Valeur: donneesClinimetreValeurs,
                donnees_Clinimetre_Objectifs: donneesClinimetreObjectifs,
                date_Objectifs: dateObjectifs,
                id_Fonctions: __LISTEGRILLES__[idGrille].idFonctions
            },
            dataType: 'json',
            success: function (res) {
                console.log(res);
                // On montre visuellement que l'opération terminée avec succès
                $('body').css('opacity', 1);
                //location.reload();


                loadPage("pageQuestions");
                loadPage("pageListe");
                loadPage("pageRadar");


                // __PARAMETRES__.currentPage = 'pageDeConnexion';

            },
            error: function () {
                //alert("Erreur lors de l'enregistrement des donnees.");
            }
        });
    }

    // Si le navigateur est hors ligne
    else {
        alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
    }
}


//////////////////////////////////////////////////////////////////////////////////////////////////

function imprimer() {

    // Si le navigateur est en ligne
    if (navigator.onLine) {

        // Initialisation des variables
        var idEtablissement = __ETABLISSEMENT__.id;
        var idGrille = __DOCTEUR__.idLastGrille;
        var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;
        var listefonctions = $('#fonctions_liste');

        var grilleLibelle = __LISTEGRILLES__[idGrille].libelle;
        var etablissementLibelle = __ETABLISSEMENT__.libelle;

        var libFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
        var donneesClinimetre = getBufferedDataClinimetre();
        currentDate = new Date(__PARAMETRES__.dateLastSync);
        var strDte = dateToString(currentDate);


        //----------------------------------------------------------------------------------

        // transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
        // Car la date reste la même...

        var donneesClinimetreValeurs = [];

        for (var g = 1; g < donneesClinimetre.length; g++) {

            if (typeof donneesClinimetre[g] == 'undefined') {
                donneesClinimetreValeurs[g] = 0;
            }
            else {
                donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
            }

        }


        //----------------------------------------------------------------------------------


        var updatesDates = getClinimetreUpdatesDates();
        var dateObjectifs = updatesDates[updatesDates.length - 1];
        var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);
        // On montre visuellement qu'une opération est en cours
        $('body').css('opacity', 0.5);

        // Mise à jour des données actuelles
        var request = $.ajax({
            url: "include/updateDonneesClinimetre.php",
            type: "POST",
            data: {
                id_Etablissement: idEtablissement,
                docteur: JSON.stringify(__DOCTEUR__),
                donnees_Clinimetre_Valeur: donneesClinimetreValeurs,
                donnees_Clinimetre_Objectifs: donneesClinimetreObjectifs,
                date_Objectifs: dateObjectifs,
                id_Fonctions: __LISTEGRILLES__[idGrille].idFonctions
            },
            dataType: 'json',
            success: function (res) {
                console.log(res);
                // On montre visuellement que l'opération terminée avec succès
                $('body').css('opacity', 1);
                // si la sauvegarde s'est bien déroulé on fait une redirection vers la page choix d'un patient
                createRadar(idGrille);
                loadPage("pageQuestions");
                loadPage("pageListe");
                loadPage("pageRadar");
                createRadar(idGrille);
            },
            error: function () {
                //alert("Erreur lors de l'enregistrement des donnees.");
            }
        });


        // On récupère les donnée du dernier patient utilé (celui en cours d'utilisation) et on stocke
        // les différentes informations à imprimer dans les variables suivantes. Le patient utilisé
        // est définie par rapport au docteur qui utilise en ce moment l'application: c'est celui utilisé
        // en dernier.
        var patient = __DOCTEUR__.idLastPatient;
        var nomImp = __LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom;
        var impNum = __LISTEPATIENTS__[patient].num_dossier;
        var impChambre = __LISTEPATIENTS__[patient].num_chambre;
        var impDateNai = __LISTEPATIENTS__[patient].date_naissance;


        var val = getCurrentDataClinimetre();
        var corps = '';
        // définition de la page à imprimer

        corps += ' <div id="pageImprime" >';

        corps += ' <br> Patient : &nbsp;' + nomImp;

        corps += ' <br> Numéro de dossier : &nbsp;' + impNum;

        corps += ' <br> Numéro de chambre : &nbsp; ' + impChambre;

        corps += ' <br> Date de naissance : &nbsp; ' + impDateNai + '<br>';

        corps += '<br><br>';
        corps += '<table style="border: 1px solid black;border-collapse: collapse;"> <tr>' +
            '<TH COLSPAN="3">' +
            '<H3><BR>&nbsp;&nbsp;Les valeurs des fonctions de la grille ' + grilleLibelle + '&nbsp;&nbsp;</H3>' +
            '</TH>' +
            '</tr>' +
            '<tr>' +
            '<th style="border: 1px solid black;border-collapse: collapse;padding: 15px;">#</th>' +
            '<th style="border: 1px solid black;border-collapse: collapse;padding: 15px;">Fonction</th>' +
            '<th style="border: 1px solid black;border-collapse: collapse;padding: 15px;">Valeur clinimétrique&nbsp;</th>' +
            '</tr>'


        console.log(val.length);

        for (var h = 0; h < val.length; h++) {
            console.log("ok");
            corps += '<tr><td>&nbsp;&nbsp;' + (h + 1) + '&nbsp;</td><td style="border: 1px solid black;border-collapse: collapse;padding: 6px;">' + libFonctions[h] + '</td><td style="border: 1px solid black;border-collapse: collapse;padding: 6px;">&nbsp;&nbsp;' + val[h] + '</td>';
        }

        corps += ' </tr></table>';


        corps += '<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Le total de cette grille est : <strong>' + document.getElementById("totalScore").innerHTML + '</strong></div>';

        listefonctions.html(corps);


        // fonction qui fait l'action d'imprimer la page
        imprimer_bloc(etablissementLibelle, 'pageImprime');

        loadPage("pageListe");
        loadPage("pageQuestions");
        loadPage("pageRadar");


    }

    // Si le navigateur est hors ligne
    else {
        alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////////

function afficher_reponse(titre, id_page) {
    var zone = document.getElementById(id_page).innerHTML;
    var fen = window.open("", "", "height=618, width=1000,toolbar=0, menubar=0, scrollbars=1, resizable=1,status=0, location=0, left=10, top=10");
    fen.document.body.style.color = '#000000';
    fen.document.body.style.backgroundColor = '#FFFFFF';
    fen.document.body.style.padding = "20px";

    // Ajout des données a imprimer
    fen.document.title = titre;
    fen.document.body.innerHTML += " " + zone + " ";

    return true;
}

function imprimer_bloc(titre, objet) {
    // Définition de la zone à imprimer
    var zone = document.getElementById(objet).innerHTML;

    // Ouverture du popup
    var fen = window.open("", "", "height=618, width=1000,toolbar=0, menubar=0, scrollbars=1, resizable=1,status=0, location=0, left=10, top=10");

    // style du popup
    fen.document.body.style.color = '#000000';
    fen.document.body.style.backgroundColor = '#FFFFFF';
    fen.document.body.style.padding = "20px";

    // Ajout des données a imprimer
    fen.document.title = titre;
    fen.document.body.innerHTML += " " + zone + " ";

    // Impression du popup
    fen.window.print();

    //Fermeture du popup
    fen.window.close();
    return true;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////

// Fonction d'impression en excel des données en cours


function imprimerExcel() {

    // Si le navigateur est en ligne
    if (navigator.onLine) {

        // Initialisation des variables
        var idEtablissement = __ETABLISSEMENT__.id;
        var idGrille = __DOCTEUR__.idLastGrille;
        var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;
        var listefonctions = $('#fonctions_liste');
        var libFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
        var donneesClinimetre = getBufferedDataClinimetre();
        currentDate = new Date(__PARAMETRES__.dateLastSync);
        var strDte = dateToString(currentDate);


        //----------------------------------------------------------------------------------

        // transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
        // Car la date reste la même...

        var donneesClinimetreValeurs = [];

        for (var g = 1; g < donneesClinimetre.length; g++) {

            if (typeof donneesClinimetre[g] == 'undefined') {
                donneesClinimetreValeurs[g] = 0;
            }
            else {
                donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
            }

        }


        //----------------------------------------------------------------------------------


        var updatesDates = getClinimetreUpdatesDates();
        var dateObjectifs = updatesDates[updatesDates.length - 1];
        var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);
        // On montre visuellement qu'une opération est en cours
        $('body').css('opacity', 0.5);

        // Mise à jour des données actuelles
        var request = $.ajax({
            url: "include/updateDonneesClinimetre.php",
            type: "POST",
            data: {
                id_Etablissement: idEtablissement,
                docteur: JSON.stringify(__DOCTEUR__),
                donnees_Clinimetre_Valeur: donneesClinimetreValeurs,
                donnees_Clinimetre_Objectifs: donneesClinimetreObjectifs,
                date_Objectifs: dateObjectifs,
                id_Fonctions: __LISTEGRILLES__[idGrille].idFonctions
            },
            dataType: 'json',
            success: function (res) {
                console.log(res);
                // On montre visuellement que l'opération terminée avec succès
                $('body').css('opacity', 1);
                // si la sauvegarde s'est bien déroulé on fait une redirection vers la page choix d'un patient
                loadPage("pageListe");
                loadPage("pageQuestions");
                loadPage("pageRadar");
            },
            error: function () {
                //alert("Erreur lors de l'enregistrement des donnees.");
            }
        });


        // On récupère les donnée du dernier patient utilé (celui en cours d'utilisation) et on stocke
        // les différentes informations à imprimer dans les variables suivantes. Le patient utilisé
        // est définie par rapport au docteur qui utilise en ce moment l'application: c'est celui utilisé
        // en dernier.
        var patient = __DOCTEUR__.idLastPatient;
        var nomImp = __LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom;
        var impNum = __LISTEPATIENTS__[patient].num_dossier;
        var impChambre = __LISTEPATIENTS__[patient].num_chambre;
        var impDateNai = __LISTEPATIENTS__[patient].date_naissance;


        var val = getCurrentDataClinimetre();
        var corps = '';
        // définition de la page à imprimer

        corps += ' <div id="pageImprime" >';

        corps += ' <br> numero de dossier : &nbsp;' + impNum;

        corps += ' <br> numero de chambre : &nbsp; ' + impChambre;

        corps += ' <br> Date de naissance : &nbsp; <br> ' + impDateNai;


        console.log(val.length);

        for (var h = 1; h < val.length; h++) {
            console.log("ok");
            corps += ' fonction: ' + libFonctions[h] + '  &nbsp; valeur:  ' + val[h] + ' <br> ';
        }

        corps += ' </div> ';

        listefonctions.html(corps);


        // fonction qui fait l'action d'imprimer la page
        imprimer_bloc(nomImp, 'pageImprime');

        loadPage("pageListe");
        loadPage("pageQuestions");
        loadPage("pageRadar");


    }

    // Si le navigateur est hors ligne
    else {
        alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
    }
}


/////////////////////////////////////////////////////////////////////////////////////////////

// Affiche et gère le menu de recherche de patient

function loadSearchAutoCompletion() {

    // On affiche notre recherche semiautomatique
    $("#searchAfterConnection").removeClass("hidden");

    // On charge la liste de nos patients
    var availableTags = [];
    for (patient in __LISTEPATIENTS__) {
        availableTags.push(__LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom);
    }

    // On active l'autocompletion
    $("#tags").autocomplete({
        source: availableTags,

        select: function (event, ui) {
            for (patient in __LISTEPATIENTS__) {

                // On ajoute les infos du patient concerné
                if (__LISTEPATIENTS__[patient].nom + ' ' + __LISTEPATIENTS__[patient].prenom == ui.item.value) {
                    $("#nomSearch").text(__LISTEPATIENTS__[patient].nom);
                    $("#prenomSearch").text(__LISTEPATIENTS__[patient].prenom);
                    $("#adresseSearch").text(__LISTEPATIENTS__[patient].num_chambre);
                    $("#dossierSearch").text(__LISTEPATIENTS__[patient].num_dossier);
                    $("#dateNaissanceSearch").text(__LISTEPATIENTS__[patient].date_naissance);

                    __DOCTEUR__.idLastPatient = patient;
                }
            }
        }
    });
}


// Adapte la taille du radar à l'espace disponible
function adaptListeRadarSize() {

    // Debut précalculs
    var w = Math.min($(window).width(), $(window).height() - 325);
    var h = Math.max($(window).width(), $(window).height() - 325);
    var v = (h - w) / 2;

    // Si c'est la page liste
    if (__PARAMETRES__.currentPage == 'pageListe') {
        $('#fonctions_liste').css('height', w);
        $('#champs').css('height', w - 50);
    }

    // Sinon on adapte la mise en page du radar
    else if (__PARAMETRES__.currentPage == 'pageRadar') {
        $('#spidergraphcontainer').css('left', v + 'px');
        $('#spidergraphcontainer').css('width', w + 'px');
        $('#spidergraphcontainer').css('height', w + 'px');
    }
}


// Renvoie la liste des valeurs modifiées depuis la dernière synchro avec la bdd
function getBufferedDataClinimetre() {

    var idGrille = __DOCTEUR__.idLastGrille;
    var idPatient = __DOCTEUR__.idLastPatient;

    var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
    var donneesPatient = __DONNEESCLINIMETRE__[idPatient][idGrille];
    var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;

    var updatesDates = getClinimetreUpdatesDates();
    var dateObjectifs = updatesDates[updatesDates.length - 1];

    var valeursBuffered = [];
    var currentDate = '';
    var j = 0;
    var fini = false;

    for (var i = 0; i < nbChampsGrille; i++) {

        fini = false;

        // On part du jour de la dernière synchronisation avec la BDD
        currentDate = new Date(__PARAMETRES__.dateLastSync);

        // Longueur de l'analyse/objectif max (1 an)
        j = 365;

        while (!fini) {

            // Modification de la date de la recherche
            strDte = dateToString(currentDate);

            if (typeof donneesPatient[idFonctions[i]][strDte] !== 'undefined') {
                // Insertion de la valeur
                valeursBuffered[idFonctions[i]] = [];
                valeursBuffered[idFonctions[i]][strDte] = donneesPatient[idFonctions[i]][strDte].valeur;

                /*

                 console.log("idFonctions[i] : "+idFonctions[i]);
                 console.log("donneesPatient[idFonctions[i]][strDte].valeur : "+ typeof donneesPatient[idFonctions[i]][strDte].valeur);
                 console.log("donneesPatient[idFonctions[i]][strDte].valeur : "+ donneesPatient[idFonctions[i]][strDte].valeur);

                 */
                //fini=true;
            }

            // Si on a atteind la dernière date, ou qu'on a atteind la limite contre les boucles infinies
            if (strDte == dateObjectifs || j == 0) {
                fini = true;
            } else {
                currentDate.setDate(currentDate.getDate() + 1);
                j--;
            }
        }
    }

    return valeursBuffered;
}

// Fonction Du Grand Pierre Le-Bouar !! 
// Le-Bouar est débile, espece de con.

//fonction question

function questionFonctions() {
    var i = parseInt($('#thermometre').attr('name'));
    //On prends la taille de la fonction
    var idGrille = __DOCTEUR__.idLastGrille;
    var idPatient = __DOCTEUR__.idLastPatient;

    var id_fonction = __LISTEGRILLES__[idGrille].idFonctions[i];

    var questions = __LISTEGRILLES__[idGrille].questionFonction;
    var temp = [];
    for (var j = 0; j < questions.length; j++) {
        if (questions[j][__LISTEGRILLES__[idGrille].idFonctions[i]] != null)
            temp[j] = questions[j][id_fonction];
    }

    temp = temp.filter(function (n) {
        for (var k = 0; k < n.length; k++) {
            return n[k] != [];
        }
    });

    //On mets à jour le titre de la fonction dans le pop up
    document.getElementById("titre_fonct").innerHTML = 'Questions de: ' + __LISTEGRILLES__[idGrille].libelleFonctions[i];

    //On mets à jour la description de la fonction
    var texte = $("#presentation_fonct");
    // On régle la taille du pop up
    document.getElementById("popup").style.height = '90%';
    document.getElementById("titre_fonct").style.height = '40px';
    document.getElementById("presentation_fonct").style.height = '87%';

    var corps = __LISTEGRILLES__[idGrille].idFonctions[i];
    corps += '<br> <div><br>';

    console.log("Les fonction de lkijuhg: " + JSON.stringify(temp));

    corps += '<div><form id="myFormFonction">';
    for (var f = 0; f < temp.length; f++) {

        corps += '<strong>Question n°' + (f + 1) + ': </strong>' + temp[f][0] + '<br><span class="dateRG" id ="' + temp[f][2] + 'datef"></span><br>';
        if (temp[f][1] == 'texte') {
            corps += '<textarea rows="4" cols="50" id="' + temp[f][2] + 'f" name="' + temp[f][2] + '" placeholder="Ecrivez votre texte ici"/><br>';
            corps += '<button onclick="saveOneResponseF(' + temp[f][2] + ')">Enregistrer</button><br>';
        } else if (temp[f][1] == 'num') {
            corps += '<input type="number" id="' + temp[f][2] + 'f" name="' + temp[f][2] + '" min=0 ><br>';
            corps += '<button onclick="saveOneResponseF(' + temp[f][2] + ')">Enregistrer</button><br>';
        } else if (temp[f][1] == 'O/N') {
            corps += '<input type="radio" id="' + temp[f][2] + 'f" name="' + temp[f][2] + '" value="Oui">Oui<br>';
            corps += '<input type="radio" id="' + temp[f][2] + 'secf" name="' + temp[f][2] + '" value="Non">Non<br>';
            corps += '<button onclick="saveOneResponseF(' + temp[f][2] + ')">Enregistrer</button><br>';
        }

        corps += '<br>';
    }
    corps += '<input type="submit" id="btnReponsesFonction"  value="Enregistrer les reponses">';
    corps += '</form><br>';
    corps += '<button onclick="getResponseFonction()">Voir réponses</button><br>';

    corps += '</div></div>';

    texte.html(corps);

    fillResponseFonctions(idGrille, idPatient);

}


function saveOneResponseF(id_question) {

    var rep = document.getElementById(id_question + 'f');
    var idQuestion = '';
    var reponse = '';
    var id_patient = __DOCTEUR__.idLastPatient;

    console.log("testoto : " + rep);

    if (rep.type == 'radio') {
        if (rep.checked) {
            idQuestion = rep.name;
            reponse = rep.value;
        } else {
            idQuestion = rep.name;
            reponse = 'Non';
        }
    } else {
        idQuestion = rep.name;
        reponse = rep.value;
    }


    var request = $.ajax({
        url: "include/saveOneRFonction.php",
        type: "POST",
        data: {

            idQuestion: idQuestion,
            id_patient: id_patient,
            reponse: reponse
        },
        dataType: 'json',
        success: function (res) {
            console.log(res);

            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //January is 0!
            var yyyy = today.getFullYear();

            if (dd < 10) {
                dd = '0' + dd
            }

            if (mm < 10) {
                mm = '0' + mm
            }

            today = yyyy + '-' + mm + '-' + dd;
            $("#" + idQuestion + "datef").text(today);
            // On montre visuellement que l'opération terminée avec succès
            //location.reload();


        },
        error: function () {

            alert("Erreur lors de l'enregistrement des reponses de cette grille: " + id_grille);
        }
    });

}


function fillResponseFonctions(idGrille, idPatient) {
    var reponse = __LISTEGRILLES__[idGrille].repAll;
    for (var i = 0; i < reponse.length; i++) {
        if (reponse[i].id_patient == idPatient) {
            var id_question = reponse[i].id_question;
            if (reponse[i].type == 'O/N') {
                if (reponse[i].reponse == 'Oui') {
                    $("#" + id_question + "f").prop("checked", true);
                } else {
                    $("#" + id_question + "secf").prop("checked", true);
                }
            } else {
                $("#" + id_question + "f").val(reponse[i].reponse);
            }
            $("#" + id_question + "datef").text(reponse[i].date);

        }

    }
}


function getResponseFonction() {
    var id_grille = __DOCTEUR__.idLastGrille;
    var id_patient = __DOCTEUR__.idLastPatient;
    var i = parseInt($('#thermometre').attr('name'));
    var id_fonction = __LISTEGRILLES__[id_grille].idFonctions[i];

    var nomPatient = __LISTEPATIENTS__[id_patient].nom + " " + __LISTEPATIENTS__[id_patient].prenom;
    var listefonctions = $('#fonctions_liste');

    var request = $.ajax({
        url: "include/getResponseFonction.php",
        type: "GET",
        data: {
            id_fonction: id_fonction,
            id_patient: id_patient
        },
        dataType: 'json',
        success: function (res) {

            var reponse = res.rep;
            var corps = '';

            corps += " <div id='pageReponse'>";

            corps += ' <div style="font-family:Helvetica;"><br> Patient : &nbsp;' + nomPatient + "</div><br><br>";

            $.each(reponse, function (key, value) {
                console.log(key);
                var d = new Date(key);
                corps += "<fieldset><legend style='font-family:Helvetica;'>Le " + d.toLocaleDateString() + "</legend>"; // date
                $.each(value, function (key1, value1) {
                    $.each(value1, function (key2, value2) {
                        corps += "<div style='font-weight:bold;font-size:17px;font-family:Helvetica;'>" + key2 + "</div>"; // question
                        $.each(value2, function (key3, value3) {
                            corps += "<div style='font-family:Helvetica;'>" + value3 + "</div><br>"; //reponse
                        });
                    });
                });
                corps += "</fieldset><br>";

            });

            corps += "</div>";

            listefonctions.html(corps);
            afficher_reponse("Reponses du patient: " + nomPatient, 'pageReponse');

            // Ne pas oublier de de-commenter
            loadPage("pageListe");
            loadPage("pageQuestions");

        },
        error: function () {

            alert("Pas possible d'obtenir les reponses de cette fonction: " + id_fonction);
        }
    });
}


function enregistrerReponsesFonction() {
    var id_grille = __DOCTEUR__.idLastGrille;
    var id_patient = __DOCTEUR__.idLastPatient;
    var i = parseInt($('#thermometre').attr('name'));
    var id_fonction = __LISTEGRILLES__[id_grille].idFonctions[i];


    var reponsesFonction = [];

    var formQuestion = document.getElementById("myFormFonction").elements;
    for (var j = 0; j < formQuestion.length - 1; j++) {
        //console.log('best duck ever : type: '+formQuestion[j].type+' name: '+formQuestion[j].name);
        reponsesFonction[j] = [];

        if (formQuestion[j].type == 'radio') {
            if (formQuestion[j].checked) {
                reponsesFonction[j][0] = formQuestion[j].name;
                reponsesFonction[j][1] = formQuestion[j].value;
            }
        } else {
            reponsesFonction[j][0] = formQuestion[j].name;
            reponsesFonction[j][1] = formQuestion[j].value;
        }
    }
    reponsesFonction = reponsesFonction.filter(function (n) {
        for (var j = 0; j < n.length; j++) {
            return n[j] != [];
        }
    });


    console.log('haaaa daaamn:' + JSON.stringify(reponsesFonction));

    var request = $.ajax({
        url: "include/saveResponseFonction.php",
        type: "POST",
        data: {
            id_patient: id_patient,
            reponses: reponsesFonction
        },
        dataType: 'json',
        success: function (res) {
            console.log(res);
            // On montre visuellement que l'opération terminée avec succès
            //location.reload();
            
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //January is 0!
            var yyyy = today.getFullYear();

            if (dd < 10) {
                dd = '0' + dd
            }

            if (mm < 10) {
                mm = '0' + mm
            }

            today = yyyy + '-' + mm + '-' + dd;
            for (var j = 0; j < reponsesFonction.length; j++) {

                $("#" + reponsesFonction[j][0] + "datef").text(today);
            }

        },
        error: function () {

            alert("Erreur lors de l'enregistrement des reponses de cette fonction: " + id_fonction);
        }
    });

}


//fonction question
function sauv_rep_question() {
    var i = 0;
    //On prends la taille de la fonction
    var idGrille = __DOCTEUR__.idLastGrille;
    var idPatient = __DOCTEUR__.idLastPatient;
    var question, reponse, champ_question, champ_reponse;
    var a = 0;
    var b = 0;
    var nomcase = 0;
    var idQuestion;

    champ_question = __LISTEGRILLES__[idGrille].questionLoupe[a][1];
    reponse = __LISTEGRILLES__[idGrille].reponseLoupe[b][1];

    while (typeof __LISTEGRILLES__[idGrille].questionLoupe[a] != 'undefined') {

        champ_question = __LISTEGRILLES__[idGrille].questionLoupe[a][1];
        question = __LISTEGRILLES__[idGrille].questionLoupe[a][0];
        //console.log(__REPONSEPATIENT__);

        if (champ_question.toUpperCase() == $("#grille_fonction").text().toUpperCase()) {
            b = 0;

            while (typeof __LISTEGRILLES__[idGrille].reponseLoupe[b] != 'undefined') {
                champ_reponse = __LISTEGRILLES__[idGrille].reponseLoupe[b][1];
                reponse = __LISTEGRILLES__[idGrille].reponseLoupe[b][0];
                if (champ_reponse.toUpperCase() == champ_question.toUpperCase() && __LISTEGRILLES__[idGrille].reponseLoupe[b][2] == __LISTEGRILLES__[idGrille].questionLoupe[a][2]) {
                    nomcase = 'case' + a;
                    nomcase = nomcase + b;
                    nomcase = '#' + nomcase;
                    console.log(nomcase);
                    console.log($(nomcase).prop("checked"));
                    if ($(nomcase).prop("checked")) {
                        console.log('checked');
                        idQuestion = __LISTEGRILLES__[idGrille].reponseLoupe[b][2];

                        var requete = $.ajax(
                            {
                                url: "include/questionnaire.php",
                                type: "POST",
                                data: {
                                    idDocteur: __DOCTEUR__.id,
                                    idPatient: idPatient,
                                    idGrille: idGrille,
                                    idQuestion: idQuestion,
                                    champ: champ_reponse.toUpperCase(),
                                    reponse: reponse.toUpperCase(),
                                    etat: 1
                                },
                                dataType: "json",
                                async: false,
                                success: function (res) {

                                    var varReponsePatient = $.extend(true, __REPONSEPATIENT__, res);
                                    localStorage.setItem('reponsePatient', JSON.stringify(__REPONSEPATIENT__));
                                    console.log(__REPONSEPATIENT__);

                                }
                            }).done(function () {
                                console.log('sauvegarde de la reponse ' + reponse);
                            });
                        console.log(JSON.parse(localStorage.getItem('reponsePatient')));

                    }
                    else {
                        console.log('unchecked');
                        idQuestion = __LISTEGRILLES__[idGrille].reponseLoupe[b][2];

                        var requete = $.ajax(
                            {
                                url: "include/questionnaire.php",
                                type: "POST",
                                data: {
                                    idDocteur: __DOCTEUR__.id,
                                    idPatient: idPatient,
                                    idGrille: idGrille,
                                    idQuestion: idQuestion,
                                    champ: champ_reponse.toUpperCase(),
                                    reponse: reponse.toUpperCase(),
                                    etat: 0
                                },
                                dataType: "json",
                                async: false,
                                success: function (res) {

                                    var varReponsePatient = $.extend(true, __REPONSEPATIENT__, res);
                                    localStorage.setItem('reponsePatient', JSON.stringify(__REPONSEPATIENT__));
                                    console.log(__REPONSEPATIENT__);
                                }
                            }).done(function () {
                                console.log('sauvegarde de la reponse ' + reponse);
                            });

                    }
                }
                b++;
            }
        }
        a++;
    }

}


function aideInterrogation() {
    //On prends la taille de la fonction
    var idGrille = __DOCTEUR__.idLastGrille;
    document.getElementById("popup").style.height = '85%';
    document.getElementById("titre_fonct").style.height = '40px';
    document.getElementById("presentation_fonct").style.height = '85%';
    document.getElementById("presentation_fonct").innerHTML = __LISTEGRILLES__[idGrille].descriptionGrille;
    document.getElementById("titre_fonct").innerHTML = __LISTEGRILLES__[idGrille].libelle;
    console.log(__LISTEGRILLES__[idGrille].descriptionGrille);
}

function aideGrille() {
    var i = parseInt($('#thermometre').attr('name'));
    //On prends la taille de la fonction
    var idGrille = __DOCTEUR__.idLastGrille;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
    var descrfonct = __LISTEGRILLES__[idGrille].descriptionFonctions[i];
    var nbr_colonne = __LISTEGRILLES__[idGrille].nombreDeColonne;

    //On adapte la taille des cases
    var popup = document.getElementById("popup");
    var nombre_case;
    nombre_case = lvlgrillemax - lvlgrillemin + 1;

    var numero_case = 0;
    var nom_case;
    var champ;
    var compt = 0;
    var tab = [0, 0];
    a = 0;
    console.log($("#grille_fonction").text().toUpperCase());

    if (typeof (__LISTEGRILLES__[idGrille].descriptionChamp[a]) != 'undefined') {
        while (compt < nombre_case) {
            champ = __LISTEGRILLES__[idGrille].descriptionChamp[a][1];

            if (champ.toUpperCase() == $("#grille_fonction").text().toUpperCase()) {
                if (typeof (__LISTEGRILLES__[idGrille].descriptionChamp[a]) != 'undefined') {
                    console.log(__LISTEGRILLES__[idGrille].descriptionChamp[a][0]);
                    tab[compt] = __LISTEGRILLES__[idGrille].descriptionChamp[a][0];
                }

                compt++;
            }
            a++;
        }
    }

    if (screen.width > 850)		//On modifie le CSS pour un pc portable
    {
        //On régle la taille du popup du titre et de la description
        document.getElementById("popup").style.height = '650px';
        document.getElementById("titre_fonct").style.height = '40px';
        document.getElementById("presentation_fonct").style.height = '110px';

        if (nbr_colonne == 1) {
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                // On modifie la taille de la case et de la description
                nom_case = 'case' + numero_case;
                var case_id = document.getElementById(nom_case);
                if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                    case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                }
                else {
                    case_id.innerHTML = numero_case;
                }
                case_id.style.marginTop = ((numero_case - 1) * (480 / nombre_case)) + 'px';
                case_id.style.height = (480 / nombre_case) + 'px';
                case_id.style.visibility = "visible";
                case_id.style.marginLeft = "0";

                nom_case = 'texte_descr' + numero_case;
                var descr_id = document.getElementById(nom_case);
                if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                    descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                }
                else {
                    descr_id.innerHTML = " ";
                }
                descr_id.style.marginTop = ((numero_case - 1) * (480 / nombre_case)) + 'px';
                descr_id.style.height = (480 / nombre_case) + 'px';
                descr_id.style.visibility = "visible";
                descr_id.style.marginLeft = "5%";
                descr_id.style.width = "95%";
                descr_id.style.fontSize = "18px";

            }
        }

        if (nbr_colonne == 2) {
            var b = 0;
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                if ((numero_case) % 2 == 1) {
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 1 - b) * (2 * 420 / nombre_case)) + 'px';
                    case_id.style.height = (2 * 420 / nombre_case) + 'px';
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 1 - b) * (2 * 420 / nombre_case)) + 'px';
                    descr_id.style.height = (2 * 420 / nombre_case) + 'px';
                    descr_id.style.width = "43%";
                    descr_id.style.visibility = "visible";
                }
                else {
                    // On modifie la case de gauche
                    nom_case = 'case' + numero_case;
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 2 - b) * (420 / nombre_case) * 2) + 'px';
                    case_id.style.height = (2 * 420 / nombre_case) + 'px';
                    case_id.style.marginLeft = "50%";
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 2 - b) * (420 / nombre_case) * 2) + 'px';
                    descr_id.style.height = (2 * 420 / nombre_case) + 'px';
                    descr_id.style.width = "45%";
                    descr_id.style.marginLeft = "55%";
                    descr_id.style.visibility = "visible";
                    b++;
                }


            }
        }
    }
    else if (screen.width < 500)		//On modifie le CSS pour un smartphone
    {
        //On régle la taille du popup du titre et de la description
        document.getElementById("popup").style.height = '230px';
        document.getElementById("titre_fonct").style.height = '10px';
        document.getElementById("presentation_fonct").style.height = '50px';

        if (nbr_colonne == 1) {
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                // On modifie la taille de la case et de la description
                nom_case = 'case' + numero_case;
                var case_id = document.getElementById(nom_case);
                if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                    case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                }
                else {
                    case_id.innerHTML = numero_case;
                }
                descr_id.style.marginTop = ((numero_case - 1) * (42 / nombre_case)) + 'px';
                case_id.style.height = (73 / nombre_case) + 'px';
                case_id.style.visibility = "visible";
                case_id.style.marginLeft = "0";

                nom_case = 'texte_descr' + numero_case;
                var descr_id = document.getElementById(nom_case);
                if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                    descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                }
                else {
                    descr_id.innerHTML = " ";
                }
                descr_id.style.marginTop = ((numero_case - 1) * (42 / nombre_case)) + 'px';
                case_id.style.height = (73 / nombre_case) + 'px';
                descr_id.style.visibility = "visible";
                descr_id.style.marginLeft = "5%";
                descr_id.style.width = "95%";
                descr_id.style.fontSize = "12px";

            }
        }

        if (nbr_colonne == 2) {
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                if ((numero_case) % 2 == 1) {
                    // On modifie la case de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = (13 + (numero_case - 1) * (45 / nombre_case)) + '%';
                    case_id.style.height = (75 / nombre_case) + '%';

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = (13 + (numero_case - 1) * (45 / nombre_case)) + '%';
                    descr_id.style.height = (75 / nombre_case) + '%';
                    descr_id.style.width = "45%";
                }
                else {
                    // On modifie la case de gauche
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = (13 + (numero_case - 2) * (45 / nombre_case)) + '%';
                    case_id.style.height = (75 / nombre_case) + '%';
                    case_id.style.marginLeft = "50%";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = (13 + (numero_case - 2) * (45 / nombre_case)) + '%';
                    descr_id.style.height = (75 / nombre_case) + '%';
                    descr_id.style.width = "45%";
                    descr_id.style.marginLeft = "55%";
                }


            }
        }
    }
    else if (screen.width < screen.height)			//On modifie le CSS pour les tablettes en portrait
    {

        //On régle la taille du popup du titre et de la description
        document.getElementById("popup").style.height = '850px';
        document.getElementById("titre_fonct").style.height = '40px';
        document.getElementById("presentation_fonct").style.height = '110px';

        for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
            // On modifie la taille de la case et de la description
            nom_case = 'case' + numero_case;
            var case_id = document.getElementById(nom_case);
            if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
            }
            else {
                case_id.innerHTML = numero_case;
            }
            case_id.style.marginTop = ((numero_case - 1) * (680 / nombre_case)) + 'px';
            case_id.style.height = (680 / nombre_case) + 'px';
            case_id.style.visibility = "visible";
            case_id.style.marginLeft = "0";

            nom_case = 'texte_descr' + numero_case;
            var descr_id = document.getElementById(nom_case);
            if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
            }
            else {
                descr_id.innerHTML = " ";
            }
            descr_id.style.marginTop = ((numero_case - 1) * (680 / nombre_case)) + 'px';
            descr_id.style.height = (680 / nombre_case) + 'px';
            descr_id.style.visibility = "visible";
            descr_id.style.marginLeft = "5%";
            descr_id.style.width = "95%";
            descr_id.style.fontSize = "18px";

        }

        if (nbr_colonne == 2) {
            var b = 0;
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                if ((numero_case) % 2 == 1) {
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 1 - b) * (2 * 600 / nombre_case)) + 'px';
                    case_id.style.height = (2 * 600 / nombre_case) + 'px';
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 1 - b) * (2 * 600 / nombre_case)) + 'px';
                    descr_id.style.height = (2 * 600 / nombre_case) + 'px';
                    descr_id.style.width = "43%";
                    descr_id.style.visibility = "visible";
                }
                else {
                    // On modifie la case de gauche
                    nom_case = 'case' + numero_case;
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 2 - b) * (600 / nombre_case) * 2) + 'px';
                    case_id.style.height = (2 * 600 / nombre_case) + 'px';
                    case_id.style.marginLeft = "50%";
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 2 - b) * (600 / nombre_case) * 2) + 'px';
                    descr_id.style.height = (2 * 600 / nombre_case) + 'px';
                    descr_id.style.width = "45%";
                    descr_id.style.marginLeft = "55%";
                    descr_id.style.visibility = "visible";
                    b++;
                }


            }
        }
    }
    else				//On modifie le CSS pour les tablettes en paysage
    {

        //On régle la taille du popup du titre et de la description
        document.getElementById("popup").style.height = '650px';
        document.getElementById("titre_fonct").style.height = '40px';
        document.getElementById("presentation_fonct").style.height = '110px';

        for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
            // On modifie la taille de la case et de la description
            nom_case = 'case' + numero_case;
            var case_id = document.getElementById(nom_case);
            if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
            }
            else {
                case_id.innerHTML = numero_case;
            }
            case_id.style.marginTop = ((numero_case - 1) * (480 / nombre_case)) + 'px';
            case_id.style.height = (480 / nombre_case) + 'px';
            case_id.style.visibility = "visible";
            case_id.style.marginLeft = "0";

            nom_case = 'texte_descr' + numero_case;
            var descr_id = document.getElementById(nom_case);
            if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
            }
            else {
                descr_id.innerHTML = " ";
            }
            descr_id.style.marginTop = ((numero_case - 1) * (480 / nombre_case)) + 'px';
            descr_id.style.height = (480 / nombre_case) + 'px';
            descr_id.style.visibility = "visible";
            descr_id.style.marginLeft = "5%";
            descr_id.style.width = "95%";
            descr_id.style.fontSize = "18px";

        }

        if (nbr_colonne == 2) {
            var b = 0;
            for (numero_case = 1; numero_case < (nombre_case + 1); numero_case++) {
                if ((numero_case) % 2 == 1) {
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 1 - b) * (2 * 420 / nombre_case)) + 'px';
                    case_id.style.height = (2 * 420 / nombre_case) + 'px';
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 1 - b) * (2 * 420 / nombre_case)) + 'px';
                    descr_id.style.height = (2 * 420 / nombre_case) + 'px';
                    descr_id.style.width = "43%";
                    descr_id.style.visibility = "visible";
                }
                else {
                    // On modifie la case de gauche
                    nom_case = 'case' + numero_case;
                    // On modifie la taille de la case et de la description de droite
                    nom_case = 'case' + numero_case;
                    var case_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1]) != 'undefined') {
                        case_id.innerHTML = __LISTEGRILLES__[idGrille].valeurFonctions[numero_case - 1];
                    }
                    else {
                        case_id.innerHTML = numero_case;
                    }
                    case_id.style.marginTop = ((numero_case - 2 - b) * (420 / nombre_case) * 2) + 'px';
                    case_id.style.height = (2 * 420 / nombre_case) + 'px';
                    case_id.style.marginLeft = "50%";
                    case_id.style.visibility = "visible";

                    nom_case = 'texte_descr' + numero_case;
                    var descr_id = document.getElementById(nom_case);
                    if (typeof (__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] != 'undefined')) {
                        descr_id.innerHTML = __LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case - 1] + ' : ' + tab[numero_case - 1];
                    }
                    else {
                        descr_id.innerHTML = " ";
                    }
                    descr_id.style.marginTop = ((numero_case - 2 - b) * (420 / nombre_case) * 2) + 'px';
                    descr_id.style.height = (2 * 420 / nombre_case) + 'px';
                    descr_id.style.width = "45%";
                    descr_id.style.marginLeft = "55%";
                    descr_id.style.visibility = "visible";
                    b++;
                }


            }
        }
    }

    //On cache les case non utilisé
    for (numero_case = nombre_case + 1; numero_case < 11; numero_case++) {
        // On modifie la taille de la case et de la description
        nom_case = 'case' + numero_case;
        var case_id = document.getElementById(nom_case);
        case_id.style.visibility = "hidden";

        nom_case = 'texte_descr' + numero_case;
        var descr_id = document.getElementById(nom_case);
        descr_id.style.visibility = "hidden";
    }

    //On mets à jour le titre de la fonction dans le pop up
    document.getElementById("titre_fonct").innerHTML = $("#grille_fonction").text().toUpperCase();
    //On mets à jour la description de la fonction
    document.getElementById("presentation_fonct").innerHTML = descrfonct;

    //On affiche le pop up
    popup.style.visibility = "visible";
}


//Fonction changeant les valeurs du clinimètre lors de l'utilisation du popup
function sauv_popup(valeur) {
    //On sauvergarde la valeur sélectionné
    saveLSClinimetreValue(grilleToClinimetre(valeur, undefined, undefined, __DOCTEUR__.idLastGrille));

    //On mets à jour le radar
    updateRadar();

    //On actualise le curseur
    var idGrille = __DOCTEUR__.idLastGrille;
    var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
    var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
    var id = parseInt($('#thermometre').attr('name'));
    var valthermo = valeur * __NBLVLTHERMO__ / nbValGrille - __NBLVLTHERMO__ / (2 * nbValGrille);
    updateCurseur(valthermo);

    //On mets à jour la valuer sur les cotés
    updateValeurClinimetreGrille(grilleToClinimetre(valeur), idGrille);

    /*if(document.getElementById('question_patient'))
     {*/
    console.log('le questionnaire est sauvegarde');
    //sauv_rep_question();

    fermeture_popup();
}

/* Fonctions d'ouverture et de fermeture du pop up */

function fermeture_popup() {
    document.getElementById("popup").style.visibility = "hidden";
    //On cache les case non utilisé
    var numero_case;
    var nom_case;

    for (numero_case = 1; numero_case <= 10; numero_case++) {
        // On modifie la taille de la case et de la description
        nom_case = 'case' + numero_case;
        var case_id = document.getElementById(nom_case);
        case_id.style.visibility = "hidden";

        nom_case = 'texte_descr' + numero_case;
        var descr_id = document.getElementById(nom_case);
        descr_id.style.visibility = "hidden";
    }

    if (document.getElementById('question_patient')) {
        console.log('le questionnaire est sauvegarde');
        sauv_rep_question();
    }

    loadPage("pageQuestions");
    loadPage("pageListe");
    loadPage("pageRadar");
    createRadar();
}

function ouverture_popup() {
    document.getElementById("popup").style.visibility = "visible";
    console.log("ouverture pop up");
}

//Surbrillance de la case du popup
function surbrillance_case(carre, texte_desc) {
    document.getElementById(texte_desc).style.backgroundColor = '#FFFFFF';
    document.getElementById(carre).style.textDecoration = 'underline';
}
function desurbrillance_case(carre, texte_desc) {
    document.getElementById(texte_desc).style.backgroundColor = '#EEEEEE';
    document.getElementById(carre).style.textDecoration = 'none';
}

//clique sur la bulle
$('html').click(function (e) {
    if ((e.target.id == 'bulle') || (e.target.id == 'popup')) {
        ouverture_popup();
        aideGrille();
    }
    else if ((e.target.id == 'grille_infos') || (e.target.id == 'popup')) {
        ouverture_popup();
        aideInterrogation();
    }
    else if ((e.target.id == 'loupe') || (e.target.id == 'popup')) {
        ouverture_popup();
        questionFonctions();
    }
    else {

    }
});


/*
 *
 *
 *
 * FIN FONCTIONS TERMINEES
 *
 *
 *
 */