function Grille(libelle, nivGrilleMin, nivGrilleMax, seuil, listeChamps, listeDescValeurs) {
	
	// Attributs et initialisation
	(typeof libelle != 'undefined') 		? this.libelle = libelle 					: this.libelle = null;
	(typeof nivGrilleMin != 'undefined') 	? this.nivGrilleMin = nivGrilleMin 			: this.nivGrilleMin = null;
	(typeof nivGrilleMax != 'undefined')	? this.nivGrilleMax = nivGrilleMax 			: this.nivGrilleMax = null;
	(typeof seuil != 'undefined')			? this.seuil = seuil 						: this.seuil = null;
	(typeof listeChamps != 'undefined')		? this.listeChamps = listeChamps 			: this.listeChamps = null;
	(typeof listeDescValeurs != 'undefined')? this.listeDescValeurs = listeDescValeurs 	: this.listeDescValeurs = null;
}

	// Getters
	Grille.prototype.getLibelle 			= function() { return this.libelle; }
	Grille.prototype.getNivGrilleMin 		= function() { return this.nivGrilleMin; }
	Grille.prototype.getNivGrilleMax 		= function() { return this.nivGrilleMax; }
	Grille.prototype.getSeuil		 		= function() { return this.seuil; }
	Grille.prototype.getListeChamps	 		= function() { return this.listeChamps; }
	Grille.prototype.getListeDescVeleurs 	= function() { return this.listeDescValeurs; }
	
	// Setters
	Grille.prototype.setLibelle 			= function(libelle) 		{ this.libelle = libelle; }
	Grille.prototype.setNivGrilleMin 		= function(nivGrilleMin) 	{ this.nivGrilleMin = nivGrilleMin; }
	Grille.prototype.setNivGrilleMax	 	= function(nivGrilleMax) 	{ this.nivGrilleMax = nivGrilleMax; }
	Grille.prototype.getSeuil			 	= function(seuil) 			{ this.seuil = seuil; }
	Grille.prototype.getListeChamps	 		= function(listeChamps)		{ this.listeChamps = listeChamps; }
	Grille.prototype.setlisteDescValeurs 	= function(listeDescValeurs){ this.listeDescValeurs = listeDescValeurs; }
	
	// Serialiseurs
	Grille.prototype.toString = function() {
		var res = "";
		
		res += "Libelle : " 								+ this.libelle + "; ";
		res += "Niveau min. de la grille : "			 	+ this.nivGrilleMin + "; ";
		res += "Niveau max. de la grille : "			 	+ this.nivGrilleMax + "; ";
		res += "Seuil	: " 								+ this.seuil + "; ";
		res += "Liste des champs : [" 						+ this.listeChamps + "]; ";
		res += "Liste descriptive des valeurs : ["			+ this.listeDescValeurs + "];";
		
		return res;
	}
	
	Grille.prototype.toJSON = function() {
		var res = "{";
		
		res += "libelle				: '" + this.libelle + "', ";
		res += "nivGrilleMin		: '" + this.nivGrilleMin + "', ";
		res += "nivGrilleMax		: '" + this.nivGrilleMax + "', ";
		res += "seuil				: '" + this.seuil + "', ";
		res += "listeChamps			: [" + this.listeChamps + "], ";
		res += "listeDescValeurs	: [" + this.listeDescValeurs + "]";
		
		res += "}";
		
		return res;
	}